package Ex10_3
  model Ex10_3_a
  
    //The fluid is air
    extends Modelica.Math;
    
    // Variables
    Real p2(unit = "kPa")                                         "Pressure";
    Real W(unit = "kJ")                                           "Work";
    Real delta_u(unit = "kJ/kg")                                  "Final temperature";
    
    // Parameters
    parameter Real T1(unit = "K") = 523                     "Temperature at state 1";
    parameter Real p1(unit = "kPa") = 300                   "Pressure at state 1";
    parameter Real v1(unit = "m^3/kg") = 16                 "Specific volume at state 1";
    parameter Real v2(unit = "m^3/kg") = 1                  "Specific volume at state 2";
    parameter Real u1(unit = "kJ/kg") = 0                  "Internal energy at state 1";
    parameter Real u2(unit = "kJ/kg") = 0                  "Internal energy at state 2";
    parameter Real R(unit = "kJ/kg*K") = 0.287              "Gas constant";
    final constant Real e = Modelica.Math.exp(1.0);
    // Equations
  equation
    p2 = p1 * v1 / v2;
    W = R * T1 * log(v2 / v1);
    delta_u=u2-u1;
    
  end Ex10_3_a;
    //=================================================================================================

   model Ex10_3_b
    //The fluid is steam
    
    // Variables
    Real v2(unit = "m^3/kg")            "Specific volume";
    Real s2(unit = "kJ/kg*K")           "Entropy";
    Real x2(unit = "")                  "Dryness fraction";
    Real u2(unit = "kJ/kg")             "Internal energy";
    Real delta_u(unit = "kJ/kg")        "Change in internal energy";
    Real Q(unit = "kJ/kg")              "Heat transfer";
    
    
    // Parameters
    parameter Real T(unit = "K") = 523                        "Temperature at state 1";
    //from the steam table at 300kPa, 250 degree celsius
    
    parameter Real v1(unit = "m^3/kg") =0.7964                 "Specific volume at state 1";
    parameter Real u1(unit = "kJ/kg") = 2728.7                 "Internal energy";
    parameter Real s1(unit = "kJ/kg*K") = 7.5165               "Entropy";
    parameter Real vf(unit = "m^3/kg") =0.00125                "Specific volume";
    parameter Real vfg(unit = "m^3/kg") =0.05013               "Specific volume";
    parameter Real sf(unit = "kJ/kg*K") =2.7927                "Entropy";
    parameter Real sfg(unit = "kJ/kg*K") =3.2802               "Entropy";
    parameter Real uf(unit = "kJ/kg") =1080.37                 "Internal energy";
    parameter Real ufg(unit = "kJ/kg") =1522                   "Internal energy";
    final constant Real e = Modelica.Math.exp(1.0);
    
    // Equations
  equation
    v2 =v1/16;
    x2=(v2-vf)/vfg;
    s2=sf+x2*sfg;
    u2=uf+x2*ufg;
    delta_u=u2-u1;
    Q=T*(s2-s1);   
    
  end Ex10_3_b;
  
//================================================================================================
end Ex10_3;
