model Ex10_9

// Variables

Real R(unit ="kJ/kg*K")                        "Gas constant";
Real T1(unit ="K")                             "Temperature";
Real W(unit ="kJ")                             "Work done in the expansion";


// Parameters
  
  parameter Real a(unit ="")=0.946               "Constant";
  parameter Real b(unit ="")=0.662               "Constant";
  parameter Real p1(unit ="kPa")=5600            "Pressure";
  parameter Real V1(unit ="m^3")=0.06            "Volume";
  parameter Real T2(unit ="K")=513               "Temperature at point 2";
  parameter Real m(unit ="kg")=1.5               "Mass of gas";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations

equation
R=a-b;
T1=p1*V1/(m*R);
W=m*(b*(T1-T2)+0.0001*(T1^2-T2^2)/2);


//Note : answer is different because of quad function.

end Ex10_9;
