model Ex11_4

extends Modelica.Math;
// Variables

Real T(unit ="K")                        "Temperature of triple point";
Real P(unit ="mm Hg")                    "Pressure of triple point";
Real Lsub(unit ="kJ/kg-mol")             "Latent heat of sublimation";
Real Lvap(unit ="kJ/kg-mol")             "Latent heat of vapourization";
Real Lfu(unit ="kJ/kg-mol")              "Latent heat of fusion";

// Parameters
  

  parameter Real R(unit ="kJ/kg*K")=8.3143         "Gas constant";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation
//Given expression : ln p= 23.03 - 3754/T

T = (3754.-3063)/(23.03-19.49);
P = exp(23.03-(3754/T));
Lsub = R*3754;
Lvap = 3063*R;
Lfu = Lsub-Lvap;

//Note: The  answer may slightly vary due to  rounding off values.
end Ex11_4;
