model Ex13_10

extends Modelica.Math;
// Variables


Real T2(unit ="K")                        "Temperature";
Real P2(unit ="kPa")                      "Pressure";
Real P3(unit ="kPa")                      "Pressure";
Real T3(unit ="K")                        "Temperature";
Real T5(unit ="K")                        "Temperature";
Real P4(unit ="kPa")                      "Pressure";
Real P5(unit ="kPa")                      "Pressure";
Real P6(unit ="kPa")                      "Pressure";
Real T6(unit ="K")                        "Temperature";
Real V6(unit ="m/s")                      "Velocity";
Real Ve(unit ="m/s")                      "Exit velocity";
Real Wp_dot(unit ="MW")                   "Propulsive power developed";
Real Q1(unit ="MW")                       "Heat addition";
Real np(unit ="%")                         "Propulsive efficiency of the cycle";


// Parameters
  
  parameter Real rp(unit ="")=10                  "Pressure ratio";  
  parameter Real T1(unit ="K")=233                "Temperature";
  parameter Real Vi(unit ="m/s")=300              "Inlet velocity";
  parameter Real Cp(unit ="kJ/kg*K")=1.005        "Specific heat at constant pressure for air";
  parameter Real y(unit ="")=1.4                  "Specific heat ratio";
  parameter Real P1(unit ="kPa")=35               "Pressure";
  parameter Real T4(unit ="K")=1373               "Temperature";
  parameter Real w(unit ="kg/s")=50               "Mass flow rate of air enters into the compressor";
  parameter Real h4(unit ="kJ/kg")=1373           "Enthalpy";
  parameter Real h3(unit ="kJ/kg")=536.66         "Enthalpy";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations

equation

T2 = T1+((Vi^2)/(2*Cp))*1e-03 ;
P2 = P1*(T2/T1)^(y/(y-1));
P3 = rp*P2;
T3 = T2*(P3/P2)^((y-1)/y);
T5 = T4-T3+T2;
P4 = P3;
P5 = P4*(T5/T4)^(y/(y-1));
P6 = P1;
T6 = T5*(P6/P5)^((y-1)/y);
V6 = sqrt(2*Cp*1000*(T5-T6)) ;
Ve = V6; 
Wp_dot = w*Vi*(Ve-Vi)*1e-06;
Q1 = w*Cp*(h4-h3)*1e-03; 			
np = Wp_dot*100/Q1;


end Ex13_10;
