model Ex13_11

extends Modelica.Math;
// Variables


Real Tb(unit ="K")                        "Temperature";
Real Td(unit ="K")                        "Temperature";
Real Wgt(unit ="kJ/kg")                   "Work done of GT plant";
Real Q1(unit ="kJ/kg")                    "Heat transfer";
Real Q1_(unit ="kJ/kg")                   "Heat transfer";
Real h4(unit ="kJ/kg")                    "Enthalpy";
Real Q1_st(unit ="kJ/kg")                 "Heat transfer";
Real Q_fe(unit ="kJ/kg")                  "Heat transfer";
Real wa_s(unit ="")                       "Mass flow rate ratio";
Real Wst(unit ="kJ/kg")                   "Work done of ST plant";
Real ws(unit ="kg/s")                     "Flow rate of steam";
Real wa(unit ="kg/s")                     "Flow rate of air";
Real wa_f(unit ="")                       "Air fuel ratio";
Real FEI(unit ="KW")                      "Fuel energy input";
Real noA(unit ="")                        "Overall Efficiency of plant";


// Parameters
  
  parameter Real rp(unit ="")=8                     "Pressure ratio";  
  parameter Real Ta(unit ="K")=288                  "Temperature";
  parameter Real Tc(unit ="K")=1073                 "Temperature";
  parameter Real Cpg(unit ="kJ/kg*K")=1.11          "Specific heat at constant pressure for gas";
  parameter Real Cpa(unit ="kJ/kg*K")=1.005         "Specific heat at constant pressure for air";
  parameter Real Cv(unit ="kJ/kg*K")=0.718          "Specific heat at constant volume";
  parameter Real R(unit ="kJ/kg*K")=0.287           "Gas constant";
  parameter Real ya(unit ="")=1.4                   "Specific heat ratio for air";
  parameter Real yg(unit ="")=1.33                  "Specific heat ratio for gas";
  parameter Real PO(unit ="kW")=190e03              "Power output";
  parameter Real CV(unit ="kJ/kg")=43300            "Calorific value";
  parameter Real h1(unit ="kJ/kg")=3775             "Enthalpy";
  parameter Real h2(unit ="kJ/kg")=2183             "Enthalpy";
  parameter Real h3(unit ="kJ/kg")=138              "Enthalpy";
  parameter Real Tm(unit ="K")=1073                 "Temperature";
  parameter Real Tmin(unit ="K")=373                "Temperature";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

Tb = Ta*(rp)^((ya-1)/ya);
Td = Tc/(rp^((yg-1)/yg));
Wgt = Cpg*(Tc-Td)-Cpa*(Tb-Ta);
Q1 = Cpg*(Tc-Tb);
Q1_ = Cpg*(Tc-Td);
h4 = h3;
Q1_st = h1-h3; 			
Q_fe = Cpg*(Tm-Tmin);
wa_s = Q1_st/Q_fe; 			// wa/ws
Wst = h1-h2;
ws = PO/(wa_s*Wgt+Wst);
wa = ws*wa_s;
wa_f =CV/1095;              //wa/wf
FEI = (wa/wa_f)*CV;
noA = PO/FEI;

//Rounding off error is there.

end Ex13_11;
