model Ex13_6

extends Modelica.Math;
// Variables

Real Wnet(unit ="kJ/kg")                      "Max work done per kg of air";
Real n_cycle(unit ="%")                       "Brayton cycle efficiency";
Real n_carnot(unit ="%")                      "Carnot cycle efficiency";
Real E(unit ="")                              "Efficiency ratio";


// Parameters
  
  parameter Real Tmax(unit ="K")=1073               "Max Temperature";  
  parameter Real Tmin(unit ="K")=300                "Min Temperature";
  parameter Real Cp(unit ="kJ/kg*K")=1.005          "Specific heat at constant pressure";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations

equation

Wnet=Cp*((sqrt(Tmax))-(sqrt(Tmin)))^2;
n_cycle=(1-(sqrt(Tmin/Tmax)))*100;
n_carnot=(1-(Tmin/Tmax))*100;
E=n_cycle/n_carnot;



end Ex13_6;
