model Ex13_8

extends Modelica.Math;
// Variables


Real T2s(unit ="K")                        "Temperature";
Real T2(unit ="K")                         "Temperature";
Real T4s(unit ="K")                        "Temperature";
Real p3(unit ="atm")                       "Pressure";
Real n(unit ="")                           "Cyclic efficiency without cooling";
Real n_cycle(unit ="")                     "Cyclic efficiency with cooling";
Real r(unit ="%")                          "% of compressor delivery air flow";


// Parameters
  
  parameter Real rp(unit ="")=8                    "Pressure ratio";  
  parameter Real T1(unit ="K")=311                 "Temperature";
  parameter Real T3(unit ="K")=1100                "Temperature";
  parameter Real Cp(unit ="kJ/kg*K")=1.005         "Specific heat at constant pressure";
  parameter Real Cv(unit ="kJ/kg*K")=0.718         "Specific heat at constant volume";
  parameter Real R(unit ="kJ/kg*K")=0.287          "Gas constant";
  parameter Real y(unit ="")=1.4                   "Specific heat ratio";
  parameter Real x(unit ="")=0.13                  "Increment added to the compressor mass flow";
  parameter Real nC(unit ="")=0.87                 "Compressor efficiency";
  parameter Real nT(unit ="")=0.9                  "Turbine efficiency";
  parameter Real p1(unit ="atm")=1                 "Pressure";
  parameter Real p2(unit ="atm")=8                 "Pressure";
  parameter Real p4(unit ="atm")=1                 "Pressure";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

//With no cooling
T2s = T1*((p2/p1)^((y-1)/y));
T2 = T1 + (T2s-T1)/nC;
p3=0.95*p2;
T4s = T3/(p3/p4)^((y-1)/y); //The  answer provided in the textbook is wrong.
n = (((T3-T4s)*nT)-((T2s-T1)/nC))/(T3-T2);
//With cooling
n_cycle = n-0.05;
r = x*100/1.13;



end Ex13_8;
