model Ex14_1

extends Modelica.Math;
// Variables


Real COP_ideal(unit ="")                        "Ideal coefficient of performance";
Real COP_actual(unit ="")                       "Actual coefficient of performance";
Real W(unit ="kW")                              "Work done";



// Parameters
  
  parameter Real T1(unit ="K")=308            "Temperature";  
  parameter Real T2(unit ="K")=268            "Temperature";
  parameter Real Q2(unit ="kW")=29            "Heat leakage from the surroundings into cold storage";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

COP_ideal=T2/(T1-T2);
COP_actual=COP_ideal/3;
W=Q2/COP_actual;

end Ex14_1;
