model Ex14_4

extends Modelica.Math;
// Variables


Real h4(unit ="kJ/kg")                       "Enthalpy";
Real h5(unit ="kJ/kg")                       "Enthalpy";
Real w(unit ="kg/s")                         "Mass flow rate";
Real RE(unit ="kJ/kg")                        "Refrigeration effect";
Real RFR(unit ="kg/h")                       "Refrigerant flow rate";
Real VFR(unit ="m^3/h")                      "Volume flow rate";
Real CD(unit ="m^3/min")                     "Compressor displacement";
Real D(unit ="cm")                           "Diameter";
Real L(unit ="cm")                           "Stroke";
Real COP(unit ="")                           "Coefficient of performance";
Real PI(unit ="kW")                          "Power required to drive the compressor";


// Parameters
  parameter Real h3(unit ="kJ/kg")=882             "Enthalpy"; 
  parameter Real h2(unit ="kJ/kg")=1034            "Enthalpy";
  parameter Real h6(unit ="kJ/kg")=998             "Enthalpy";  
  parameter Real h1(unit ="kJ/kg")=1008            "Enthalpy";
  parameter Real v1(unit ="m^3/kg")=0.084          "Specific volume";
  parameter Real t4(unit ="K")=298                 "Temperature";
  parameter Real m(unit ="tonnes")=10              "Mass";
  parameter Real nv(unit ="")=0.8                  "Volumetric efficiency";
  parameter Real N(unit ="rpm")=900                "Speed";
  parameter Real n(unit ="units")=2                "Number of cylinders of the compressor";
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation


h4 = h3-h1+h6; 
h5 = h4;
w = (m*14000)/((h6-h5)*3600);
RE=h6-h5;
RFR=m*14000/RE;
VFR=RFR*v1;
CD=VFR/(nv*60);
D = (((CD*4)/(pi*1.1*N*n))^(1/3))*100; 			// L = 1.1D; L = length; D = diameter
L = 1.1*D;
COP = (h6-h5)/(h2-h1);
PI = w*(h2-h1);

end Ex14_4;
