model Ex14_5

extends Modelica.Math;
// Variables

Real h6(unit ="kJ/kg")                 "Enthalpy";
Real pi(unit ="kPa")                   "Pressure";
Real m2(unit ="kg/s")                  "Mass flow rate";
Real m1(unit ="kg/s")                  "Mass flow rate";
Real Wc(unit ="kW")                    "Work of compression";
Real COP(unit ="")                     "Coefficient of performance";
Real m_dot(unit ="kg/s")               "Mass flow rate";
Real W_c(unit ="kW")                   "Work of compression";
Real COP_(unit ="")                    "Coefficient of performance";
Real IWC(unit ="%")                    "Increase in work of compression";
Real I_COP(unit ="%")                  "Increase in Coefficient of performance for 2nd stage compression";


// Parameters
  parameter Real m(unit ="tonnes")=30                    "Mass flow rate of the refigerant";   
  
  parameter Real p2(unit ="kPa")=1554.3                  "Pressure";
  parameter Real p1(unit ="kPa")=119.5                   "Pressure";  
  parameter Real h1(unit ="kJ/kg")=1404.6                "Enthalpy";
  parameter Real h2(unit ="kJ/kg")=1574.3                "Enthalpy";
  parameter Real h3(unit ="kJ/kg")=1443.5                "Enthalpy";
  parameter Real h4(unit ="kJ/kg")=1628.1                "Enthalpy";
  parameter Real h5(unit ="kJ/kg")=371.7                 "Enthalpy";
  parameter Real h7(unit ="kJ/kg")=181.5                 "Enthalpy";
  
  parameter Real h_1(unit ="kJ/kg")=1404.6               "Enthalpy";
  parameter Real h_2(unit ="kJ/kg")=1805.1               "Enthalpy";
  parameter Real h_3(unit ="kJ/kg")=371.7                "Enthalpy";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation
h6=h5;
pi=sqrt(p1*p2);
m2=m*3.89/(h1-h7);
m1=m2*(h2-h7)/(h3-h6);
Wc=m2*(h2-h1)+m1*(h4-h3);
COP=m*3.89/Wc;
//Single stage
m_dot=m*3.89/(h_1-h_3);           //h3=h4
W_c=m_dot*(h_2-h_1);
COP_=m*3.89/W_c;
IWC=(W_c-Wc)*100/Wc;
I_COP=(COP-COP_)*100/COP_;

end Ex14_5;
