model Ex14_8

extends Modelica.Math;
// Variables

Real m(unit ="kg/s")                   "Mass flow rate";
Real Wc(unit ="kW")                    "Power input to the compressor";
Real Q(unit ="kW")                     "Heating capacity of the system";
Real COP(unit ="")                     "Coefficient of performance";
Real n(unit ="%")                      "Isentropic compressor efficiency";


// Parameters
  parameter Real A1(unit ="m^2")=1                    "Area";   
  parameter Real V1(unit ="m^3/min")=0.6              "Volumetric flow rate";
  //at p1=2.4 bar and T1= 0 degree celsius
  parameter Real v1(unit ="K")=0.0703                 "Specific volume";  
  parameter Real h1(unit ="kJ/kg")=188.99             "Enthalpy";
  //at p2=9 bar and T1= 60 degree celsius
  parameter Real h2(unit ="kJ/kg")=219.37             "Enthalpy";
  parameter Real h2s(unit ="kJ/kg")=213.27            "Enthalpy";
  //at p2=9 bar and Sat. liquid
  parameter Real h3(unit ="kJ/kg")=71.93              "Enthalpy";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation


m=A1*V1/(v1*60);
Wc=m*(h2-h1);
Q=m*(h2-h3);
COP=Q/Wc;
n=(h2s-h1)*100/(h2-h1);

end Ex14_8;
