model Ex15_1
extends Modelica.Math;
// Variables

Real W2(unit ="kg vap/kg dry air")                     "Specific humidity at state 2";
Real hw1(unit ="kJ/kg")                                "Enthalpy";
Real W1(unit ="kg vap/kg dry air")                     "Specific humidity at state 1";
Real Pw(unit ="bar")                                   "Partial pressure of water";
Real fi(unit ="")                                      "Relative humidity";
Real mu(unit ="")                                      "Degree of saturation";
Real Pa(unit ="bar")                                   "Partial pressure of dry air";
Real Tab(unit ="K")                                    "Dry bulb temperature";
Real rho_a(unit ="kg/m^3 dry air")                     "Density of dry air";
Real rho_w(unit ="kg/m^3 dry air")                     "Density of water vapour";
Real ta(unit ="Degree celsius")                        "temperature";
Real tdb(unit ="Degree celsius")                       "Dry bulb temperature";
Real tdp(unit ="Degree celsius")                       "Dew point temperature";
Real h(unit ="kJ/kg")                                  "Enthalpy of the mixture";


// Parameters
  parameter Real P(unit ="bar")=1.0132                  "Atmospheric pressure";   
  parameter Real Ps(unit ="bar")=0.03363                "Saturation Pressure";
  parameter Real T1(unit ="K")=305                      "Dry bulb temperature";  
  parameter Real T2(unit ="K")=298                      "Wet bulb temperature";
  parameter Real hfg2(unit ="kJ/kg")=2439.9             "Enthalpy";
  parameter Real hf2(unit ="kJ/kg")=109.1               "Enthalpy";
  parameter Real hg(unit ="kJ/kg")=2559.9               "Enthalpy";
  parameter Real Cpa(unit ="kJ/kg*K")=1.005             "Specific heat at constant pressure";
  parameter Real Psat(unit ="bar")=0.048                "Saturated Pressure";
  parameter Real Ra(unit ="kJ/kg*K")=0.287              "Gas constant";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

W2 = (0.622*Ps)/(P-Ps);
hw1 = hg;
W1 = (Cpa*(T2-T1)+(W2*hfg2))/(hw1-hf2);
Pw = ((W1/0.622)*P)/(1+(W1/0.622));
fi = Pw/Psat;
mu = (Pw/Psat)*((P-Psat)/(P-Pw));
Pa = P-Pw; 
Tab = T1;
rho_a = (Pa*100)/(Ra*Tab);
rho_w = W1*rho_a;
ta = 32.; 
tdb = 32.; 
tdp = 24.1;      //at 0.03 bar
h = Cpa*ta + W1*(hg+1.88*(tdb-tdp));


end Ex15_1;
