model Ex15_2

extends Modelica.Math;
// Variables

Real W2(unit ="kg vap/kg dry air")                     "Specific humidity at exit";
Real W1(unit ="kg vap/kg dry air")                     "Specific humidity at inlet";
Real Pw1(unit ="kPa")                                  "Partial pressure of water";
Real fi(unit ="%")                                     "Relative humidity";


// Parameters
  parameter Real P(unit ="kPa")=100                    "Atmospheric pressure";   
  parameter Real Ps(unit ="kPa")=2.339                 "Saturation Pressure";
  parameter Real T1(unit ="degree celsius")=30         "Inlet temperature";  
  parameter Real T2(unit ="degree celsius")=20         "Exit temperature";
  parameter Real hfg2(unit ="kJ/kg")=2454.1            "Enthalpy";
  parameter Real hf2(unit ="kJ/kg")=83.96              "Enthalpy";
  parameter Real hw1(unit ="kJ/kg")=2556.3             "Enthalpy";
  parameter Real Cpa(unit ="kJ/kg*K")=1.005            "Specific heat at constant pressure";
  parameter Real Ps1(unit ="kPa")=4.246                "Saturated Pressure";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation
W2 = (0.622*Ps)/(P-Ps);
W1 = (Cpa*(T2-T1)+(W2*hfg2))/(hw1-hf2);
Pw1 = ((W1/0.622)*P)/(1+(W1/0.622));
fi = (Pw1/Ps1)*100;


end Ex15_2;
