model Ex15_7

extends Modelica.Math;
// Variables
Real h2(unit ="kJ/kg dry air")              "Enthalpy";
Real W3(unit ="kg vap/kg dry air")          "Specific humidity";
Real G(unit ="kg/min")                      "Amount of dry air supplied";
Real CC(unit ="Tonnes")                     "Cooling coil capacity";
Real R(unit ="kg/h")                        "Capacity of the humidifier";


// Parameters
  parameter Real h1(unit ="kJ/kg")=57                      "Enthalpy";   
  parameter Real h3(unit ="kJ/kg")=42                      "Enthalpy";
  parameter Real W1(unit ="kg vap/kg dry air")=0.0065      "Specific humidity";
  parameter Real W2(unit ="kg vap/kg dry air")=0.0088      "Specific humidity";
  parameter Real t2(unit ="degree celsius")=34.5           "Temperature";
  parameter Real v1(unit ="m^3/kg dry air")=0.896          "Specific volume";
  parameter Real n(unit ="units")=1500                     "Seating capacity of hall";
  parameter Real a(unit ="m^3/min per person")=0.3         "Amount of out door air suplied";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation
 

h2 = h1;
W3 = W2;
G = (n*a)/v1 ; 			
CC = (G*(h2-h3)*60)/14000; 		
R = G*(W2-W1)*60;


end Ex15_7;
