model Ex15_8
extends Modelica.Math;
// Variables
Real hw34(unit ="kJ/kg")                  "Enthalpy";
Real tw4(unit ="degree celsius")          "Temperature drop of water";
Real A(unit ="degree celsius")            "Approach";
Real R(unit ="degree celsius")            "Range";
Real x(unit ="kg/kg dry air")             "Fraction of water evaporated";


// Parameters
  parameter Real twb1(unit ="degree celsius")=15.2        "Wet bulb temperature";   
  parameter Real twb2(unit ="degree celsius")=26.7        "Wet bulb temperature";
  parameter Real tw3(unit ="degree celsius")=30           "Wet bulb temperature";
  parameter Real h1(unit ="kJ/kg")=43                     "Enthalpy";
  parameter Real h2(unit ="kJ/kg")=83.5                   "Enthalpy";
  parameter Real hw(unit ="kJ/kg")=84                     "Enthalpy";
  parameter Real mw(unit ="kg/kg dry air")=1.15           "Mass flow rate of water";
  parameter Real W1(unit ="kg vap/kg dry air")=0.0088     "Specific humidity";
  parameter Real W2(unit ="kg vap/kg dry air")=0.0213     "Specific humidity";
  parameter Real hw3(unit ="kJ/kg")=125.8                 "Enthalpy";
  parameter Real hm(unit ="kJ/kg")=84                     "Enthalpy";
  parameter Real G(unit ="kg vap/kg dry air")=1           "";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

hw34 = (G/mw)*((h2-h1)-(W2-W1)*hw);  			// hw3-hw4
tw4 = tw3-(hw34/4.19);
A = tw4-twb1;
R = tw3-tw4;
x = G*(W2-W1);

end Ex15_8;
