model Ex16_13
extends Modelica.Math;
// Variable

Real b(unit ="")                              "Constant";
Real C(unit ="kJ/kg")                         "";
Real a(unit ="")                              "Constant";
Real n_fuel(unit ="")                         "Fuel efficiency";
Real Qcv(unit ="kW")                          "Rate of heat transfer from the engine";
Real n2(unit ="")                             "Second law efficiency of the engine";

// Parameters

  
  parameter Real Wcv(unit ="kW")=1              "Power developed by engine";
  parameter Real ach(unit ="kJ")=5407843        "chemical energy of liquid octane";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation

b = 8./(0.114+0.029); 			// By carbon balance
C = 18./2;            			// By hydrogen balance
a = b*0.114 + (b/2)*0.029 + b*0.016 + C/2 ; 			// By oxygen balance
n_fuel = (0.57*1)/(3600*114.22);
Qcv = Wcv-n_fuel*3845872; 			

// Part (b)
n2 = Wcv/(n_fuel*ach);


end Ex16_13;
