model Ex16_2

extends Modelica.Math;
// Variable

Real K(unit ="atm")                              "";
Real eps_e_1(unit ="")                           "Degree of dissociation";       
Real dH(unit ="KJ/kg-mol")                       "Average heat of reaction";

// Parameters

  parameter Real eps_e(unit ="")=0.27              "Degree of dissociation";   
  parameter Real P(unit ="bar")=1                  "Pressure ";   
  parameter Real P1(unit ="mm Hg")=100             "Pressure";   
  parameter Real T1(unit ="K")=318                 "Temperature";
  parameter Real T2(unit ="K")=298                 "Temperature";
  parameter Real R(unit ="kJ/kg*K")=8.3143         "Gas constant";
  parameter Real K1(unit ="")=0.664                "Constant of dissociation";
  parameter Real K2(unit ="")=0.141                "Constant of dissociation";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation

K = (4*eps_e^2*P)/(1-eps_e^2);
eps_e_1 = sqrt((K*760/P1)/(4+(K*760/P1)));
dH = 2.30*R*((T1*T2)/(T1-T2))*(log(K1/K2));


//The  answer provided in the textbook is wrong
end Ex16_2;
