model Ex17_4

extends Modelica.Math;
// Variables
Real Toy(unit ="K")                          "Temperature";
Real Tx(unit ="K")                           "Temperature";
Real Ty(unit ="K")                           "Temperature";
Real Pox(unit ="kPa")                        "Pressure";



// Parameters
  parameter Real Px(unit ="kPa")=16                   "Pressure";   
  parameter Real Poy(unit ="kPa")=70                  "Pressure";
  parameter Real Mx(unit ="")=1.735                   "Mach number";
  parameter Real Pyx(unit ="kPa")=3.34                "Pressure";
  parameter Real rho_yx(unit ="kg/m^3")=2.25          "Density ratio";         //rho y/rho x    
  parameter Real Tyx(unit ="")=1.483                  "Temperature ratio";
  parameter Real Poyox(unit ="")=0.84                 "Pressure ratio";        //Poy/Pox
  parameter Real My(unit ="")=0.631                   "Mach number";
  parameter Real Tox(unit ="K")=573                   "Temperature";
  parameter Real y(unit ="")=1.4                      "Specific heat ratio";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation 

Toy = Tox;
Tx = Tox/(1+((y-1)/2)*Mx^2);
Ty = Tyx*Tx;
Pox = Poy/Poyox ;

end Ex17_4;
