model Ex18_2

extends Modelica.Math;
// Variable
Real P4(unit ="kPa")                             "Pressure";
Real P2(unit ="kPa")                             "Pressure";
Real P3(unit ="kPa")                             "Pressure";       
Real Vc(unit ="cm^3")                            "Clearance volume";
Real V1(unit ="cm^3")                            "Total volume";
Real V4(unit ="cm^3")                            "Volume";
Real W(unit ="J")                                "Work done";
Real P(unit ="kW")                               "Indicated power";
Real n_volumetric(unit ="%")                     "Volumetric efficiency";
Real m(unit ="kg")                               "Mass of air compressed per cycle";
Real m_dot(unit ="kg/min")                       "Mass flow rate";
Real FAD(unit ="m^3/min")                        "Free air delivery";
Real Wt(unit ="J")                               "Turbine work";
Real n_isothermal(unit ="%")                     "Isothermal efficiency";
Real ip(unit ="kW")                              "Input power";


// Parameters

  parameter Real P1(unit ="kPa")=101.3                   "Initial pressure";
  parameter Real T1(unit ="K")=288                       "Temperature";
  parameter Real Vs(unit ="cm^3")=2000                   "Swept volume";
  parameter Real V3(unit ="cm^3")=100                    "Volume";
  parameter Real n(unit ="")=1.25                        "Polytropic index";
  parameter Real R(unit ="J/kg*K")=287                   "Gas constant";
  parameter Real N(unit ="rpm")=800                      "Speed";
  parameter Real nm(unit ="")=0.85                       "Mechanical efficiency";
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation
P4 = P1; 			
P2 = 8*P1;
P3 = P2;
Vc = V3;
V1 = Vs + Vc ;
V4 = ((P3/P4)^(1/n))*V3;
W = ((n*P1*1e03*(V1-V4)*1e-06)/(n-1))*(((P2/P1)^((n-1)/n))-1);
P = (W*N*0.001)/60 ;
n_volumetric=(V1-V4)*100/Vs;
m = (P1*1e03*(V1-V4)*1e-06)/(R*T1);
m_dot = m*N;
FAD = (V1-V4)*1e-06*N;
Wt = P1*1e03*(V1-V4)*1e-06*log(P2/P1);
n_isothermal = (Wt*N*0.001)*100/(P*60);
ip = P/nm;

end Ex18_2;
