model Ex18_9
extends Modelica.Math;
// Variable

Real T2s(unit ="K")                          "Temperature";
Real T2(unit ="K")                           "Temperature";       
Real T3(unit ="K")                           "Temperature";
Real T4s(unit ="K")                          "Temperature";
Real T4(unit ="K")                           "Temperature";
Real P(unit ="kW")                           "Total compressor Power";

// Parameters

  parameter Real T1(unit ="K")=283               "Temperature";   
  parameter Real P21(unit ="")=2.5               "Pressure ratio";   //P2/P1
  parameter Real P32(unit ="")=2.1               "Pressure ratio";   //P3/P2
  parameter Real ns(unit ="")=0.85               "Isentropic efficiency";
  parameter Real y(unit ="")=1.4                 "Index";
  parameter Real ma(unit ="kg/s")=5              "Mass flow of air";
  parameter Real Cp(unit ="kJ/kg-K")=1.005       "Specific heat at constant pressure";
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation


T2s =T1*((P21)^((y-1)/y));
T2 =T1 + (T2s-T1)/ns;
T3 = T2-50;
T4s =T3*((P32)^((y-1)/y));
T4 = T3 + ((T4s-T3)/ns);
P = ma*Cp*((T2-T1)+(T4-T3));

//note : T4 is calculted wrongly in book. please check.
// T3 is taken 322.65 K instead of 332.65 K to solve the equation of T4.
// Answer given in the book is wrong.
end Ex18_9;
