model Ex2_1

extends Modelica.Math;
//variables
Real V_ACDB(unit="m^3")                   "Volume of ACDB";
Real V_AEFB(unit="m^3")                   "Volume of AEFB";
Real T(unit="degree celsius")             "Temperature"      ;

// Parameters
   parameter Real d(unit="m")=1      "diameter";
   parameter Real l(unit="m")=1      "Length";    //Assuming

  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations 
equation

V_ACDB = (pi/4)*(1/3)*((1.05*d)^2)*10.5*l - (pi/4)*(1./3)*d^2*10*l ; 			
V_AEFB = (pi/4)*(1./3)*((1.1*d)^2)*11*l - (pi/4)*(1/3)*d^2*10*l;
T = 100*(V_ACDB/V_AEFB);



end Ex2_1;
