model Ex3_4

extends Modelica.Math;

// Variables
Real W1(unit="kJ")                            "Work done by the stirring device upon the system";
//this is negative work for the system.
Real W2(unit="kJ")                            "Work done by the system on the surroundings";
//this is positive work for the system.
Real W(unit="kJ")                             "Net work transfer for the system";

// Parameters
 parameter Real P(unit="kPa")=101.325        "Atmospheric pressure";
 parameter Real N(unit="rev.")=10000         "Number of Revolutions of stirring device";
 parameter Real T(unit="mN")=1.275           "Torque acting against the fluid";
 parameter Real D(unit="m")=0.6              "Diameter of piston";
 parameter Real L(unit="m")=0.8              "Displacement";

 final constant Real e = Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
 
// Equations
equation

//Work done by the stirring device upon the system
W1=(2*pi*T*N)/1e03;                                   

//Work done by the system upon the surroundings
W2=(P*(pi/4)*(D^2)*L);                           //W2=P*A*L

//Net work transfer for the system
W=-W1+W2;

end Ex3_4;
