model Ex4_1

// Variables
Real delta_U(unit="kJ")                               "Change in internal energy";
Real W1_2(unit="kJ")                                  "Work done";


// Parameters
 parameter Real P(unit="MPa")=0.105                   "Pressure";
 parameter Real V1(unit="m^3")=0.3                    "Initial volume";
 parameter Real V2(unit="m^3")=0.15                   "Final volume";
 parameter Real Q1_2(unit="kJ")=-37.6                 "Heat transfer from the gas";  
 
// Equations 
equation

W1_2=P*(V2-V1)*1e03;                                  //Work done
// First law of thermodynamics
delta_U=Q1_2-W1_2;                                    //Change in internal energy

end Ex4_1;
