package Ex4_2


model Ex4_2_a


// Variables
Real delta_U(unit="kJ")                          "Change in internal energy"; //delta_U=Ub-Ua
Real Q_adb(unit="kJ")                            "Heat flow into the system along path adb";

// Parameters
 parameter Real Q_acb(unit="kJ")=84                  "Heat flow into the system along path acb";
 parameter Real W_acb(unit="kJ")=32                  "Work done by the system along path acb";
 parameter Real W_adb(unit="kJ")=10.5                "Work done by the system along path adb";
 
// Equations
equation

delta_U=Q_acb-W_acb;                               //Change in internal energy

Q_adb=delta_U+W_adb;                             // Heat flow into the system along path adb

end Ex4_2_a;

//=============================================================================================

model Ex4_2_b


// Variables
Real delta_U(unit="kJ")                      "Change in internal energy"; //delta_U=Ub-Ua
Real Qb_a(unit="kJ")                         "Heat flow on the system along curved path from b to a";

// Parameters
 parameter Real Q_acb(unit="kJ")=84           "Heat flow into the system along path acb";
 parameter Real W_acb(unit="kJ")=32           "Work done by the system along path acb";
 parameter Real Wb_a(unit="kJ")=-21           "Work done on the system along curved path from b to a";
 
// Equations
equation

delta_U=Q_acb-W_acb;                         //Change in internal energy

Qb_a=-delta_U+Wb_a;                          //Heat flow on the system along curved path from b to a

end Ex4_2_b;

//==================================================================================================

model Ex4_2_c


// Variables

Real Q_ad(unit="kJ")                         "Heat flow in the system along path ad";
Real Q_db(unit="kJ")                         "Heat flow in the system along path db";



// Parameters
 parameter Real Q_adb(unit="kJ")=62.5     "Heat flow into the system along path acb"; //calculated in part a
 parameter Real W_ad(unit="kJ")=10.5      "Work done by the system along path ad";//W_adb=Wad+Wdb=Wad
 parameter Real U_a(unit="kJ")=0          "Internal energy at point a"; 
 parameter Real U_d(unit="kJ")=42         "Internal energy at point d";
 
// Equations
equation

Q_ad=(U_d-U_a)+W_ad;                          //Heat flow in the system along path ad
Q_db=Q_adb-Q_ad;                              //Heat flow in the system along path db

end Ex4_2_c;
//===============================================================================================
end Ex4_2;
