model Ex5_4


extends Modelica.Math;
// Variables

Real w2(unit="kg/s")                       "Mass flow rate of steam";


// Parameters
 

 parameter Real w1(unit="kg/s")=4.2                  "Mass flow rate of water";
 parameter Real h1(unit="kJ/kg")=313.93              "Enthalpy of water"; 
 parameter Real h2(unit="kJ/kg")=2676                "Enthalpy of steam" ; 
 parameter Real h3(unit="kJ/kg")=419                 "Enthalpy of mixture" ;
 
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations

equation
//By the nature of the process, there is no shaft work. Potential and kinetic energy terms are assumed to balance zero. The heater is assumed to be insulated. So the steady flow energy equation reduces to

w2=w1*(h1-h3)/(h3-h2);

end Ex5_4;
