model Ex6_1
// Variables
Real n_rev(unit="")                         "Reversible efficiency";
Real n_max(unit="")                         "Maximum efficiency";
Real Q1(unit="kW")                          "Heat addition";
Real Q2(unit="kW")                          "Heat rejection";


// Parameters
 parameter Real T2(unit="k")=303                   "Source temperature";  
 parameter Real T1(unit="k")=1073                  "Sink temperature";     
 parameter Real W_net(unit="kW")=1                 "Net work";
 

 
 // Equations
equation 

n_rev=1-(T2/T1);                           //Reversible efficiency
n_max=n_rev;                               //Maximum efficiency 
Q1=W_net/n_max;                            //Heat addition 
Q2=Q1-W_net;                               //Heat rejection

equation

end Ex6_1;
