model Ex6_8

// Variables
Real n_max(unit="")                              "Maximum Efficiency";
Real A(unit="m^2")                               "Minimum area required for the collector plate";
Real Q_min(unit="kJ/hr")                         "Minimum heat transfer";


// Parameters
 parameter Real T1(unit="K")=363                  "Source temperature of heat engine"; 
 parameter Real T2(unit="K")=293                  "Sink temperature of heat engine"; 
 parameter Real Q_theo(unit="kJ/m^2")=1880        "Theoretical heat transfer";   
 parameter Real W(unit="kJ/s")=1                  "Net work output";

 
 // Equations
equation 
      
n_max=1-(T2/T1);
Q_min=(W/n_max)*3600;
A=Q_min/Q_theo;


// rounding off error.
end Ex6_8;
