model Ex7_10

// Variables
Real P2(unit="KPa")                        "Final pressure";
Real delta_H(unit="kJ")                    "Change in enthalpy";
Real delta_U(unit="kJ")                    "Change in internal energy";
Real delta_S(unit="kJ")                    "Change in entropy";
Real Q1_2(unit="kJ")                       "Heat transfer";
Real W1_2(unit="kJ")                       "Work done in the process 1-2";

// Parameters
 parameter Real P1(unit="KPa")=500           "Initial pressure"; 
 parameter Real V1(unit="m^3")=0.2           "Initial Volume"; 
 parameter Real V2(unit="m^3")=0.05          "Final Volume";   
 parameter Real n(unit="")=1.3               "Polytropic index";

 
 // Equations
equation 
//For the reversible adiabatic process
P2=P1*((V1/V2)^n);
delta_H=(n*(P2*V2-P1*V1))/(n-1);
delta_U=delta_H-(P2*V2-P1*V1);
delta_S=0;
Q1_2=0;
W1_2=-delta_U;

end Ex7_10;
