package Ex8_17

model Ex8_17_a

extends Modelica.Math;
// Variables


Real delta_S_univ(unit="kJ/kg*K")               "Change in entropy";
Real I(unit="kJ/kg")                            "Irreversibility";


// Parameters
 
 parameter Real Cv(unit="kJ/kg*K")=0.718        "Speific heat at constant volume"; 
 parameter Real T1(unit="K")=300                "Initial temperature" ; 
 parameter Real T2(unit="K")=500                "Final temperature" ;
 parameter Real T0(unit="K")=300                "Surrounding temperature of air" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations

equation

delta_S_univ=Cv*log(T2/T1);
I=T0*delta_S_univ;

end Ex8_17_a;

//===============================================================================================

model Ex8_17_b

extends Modelica.Math;
// Variables

Real delta_S(unit="kJ/kg*K")                    "Change in entropy";
Real Q(unit="kJ/kg")                            "Heat transfer";
Real delta_S_univ(unit="kJ/kg*K")               "Change in entropy";
Real I(unit="kJ/kg")                            "Irreversibility";


// Parameters
 parameter Real m(unit="kg")=1                  "Mass flow rate";
 parameter Real Cv(unit="kJ/kg*K")=0.718        "Speific heat at constant volume"; 
 parameter Real T1(unit="K")=300                "Initial temperature" ; 
 parameter Real T2(unit="K")=500                "Final temperature" ;
 parameter Real T0(unit="K")=300                "Surrounding temperature of air" ;
 parameter Real T(unit="K")=600                 "Thermal reservoir temperature" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations

equation

delta_S=Cv*log(T2/T1);
Q=m*Cv*(T2-T1);
delta_S_univ=delta_S-(Q/T);
I=T0*delta_S_univ;


//The irreversibility in case (b) is less than in case (a).

end Ex8_17_b;

//===============================================================================================
end Ex8_17;
