model Ex8_2

extends Modelica.Math;
// Variables
Real mCp(unit="kJ/degree celsius")                 "Specific heat at constant pressure";
Real delta_S_water(unit="kJ/kg-K")                 "Entropy increase of 1kg water";
Real delta_S_gas(unit="kJ/K")                      "Entropy increase of 1kg gas";
Real delta_S_total(unit="kJ/K")                    "Total entropy";
Real UAE(unit="kJ")                                "Increase in unavailable energy";



// Parameters
 parameter Real L(unit="KJ/kg")=1858.5           "Latent heat of water"; 
 parameter Real T(unit="K")=493                  "Temperature at water evaporates"; 
 parameter Real T0(unit="K")=303                 "Surrounding temperature"; 
 parameter Real T1(unit="K")=1373                "Initial temperature of gas"; 
 parameter Real T2(unit="K")=823                 "Final temperature of gas";   
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations
equation 

delta_S_water=L/T;
mCp=L/(T1-T2);
delta_S_gas=mCp*log(T2/T1);
delta_S_total=delta_S_water+delta_S_gas;
UAE=T0*delta_S_total;

//The  answer may slightly vary due to  rounding off values.

end Ex8_2;
