model Ex8_6

extends Modelica.Math;
// Variables

Real W_max(unit="kJ")                       "Maximum work";
Real AE(unit="kJ")                          "Change in availability";
Real W_act(unit="kJ")                       "Actual work";
Real I(unit="kJ")                           "Irreversibility";

// Parameters
 parameter Real m(unit="kg")=2                     "Mass of air";
 parameter Real P0(unit="kPa")=100                 "Surrounding Pressure"; 
 parameter Real P1(unit="kPa")=500                 "Pressure"; 
 parameter Real R(unit="kJ/kg*K")=0.287            "Gas constant";  
 parameter Real Cv(unit="kJ/kg*K")=0.718           "Speific heat at constant volume"; 
 parameter Real T0(unit="K")=278                   "Surounding temperature"; 
 parameter Real T1(unit="K")=353                   "Air temperature" ; 
 parameter Real delta_S_system(unit="kJ")=0        "system entropy"; //for adiabatic process  
 parameter Real V1(unit="m^3")=1                   "Initial volume"      ; 
 parameter Real V2(unit="m^3")=2                   "Final volume" ; 
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations
equation
//Reseversible work in closed system.. W_max=(U1-U2)-T0*(S1-S2)
W_max=m*(Cv*(T1-T0)+T0*(Cv*log(T0/T1)+R*log(V2/V1)));
AE=W_max-((P0*2*R*T1)/P1);
W_act=T0*delta_S_system;
//irreversibility I=W_max-W_act
I=m*T0*(Cv*log(T0/T1)+R*log(V2/V1));

end Ex8_6;
