model Ex8_9

extends Modelica.Math;
// Variables

Real I(unit="kW")                       "Irreversibility rate";
Real I0(unit="kW")                      "Irreversibility rate"; 

// Parameters
 
 parameter Real m(unit="kg/s")=2                "Rate of mass flow"; 
 parameter Real Cp(unit="kJ/kg*K")=1.1          "Speific heat at constant pressure";  
 parameter Real T0(unit="K")=300                "Surounding temperature"; 
 parameter Real T1(unit="K")=1073               "Initial temperature of product" ; 
 parameter Real T2(unit="K")=1063               "Final temperature of product" ;
 parameter Real T3(unit="K")=353                "Initial temperature of air" ;
 parameter Real T4(unit="K")=343                "Final temperature of air" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations

equation

I=m*(Cp*(T1-T2)-T0*Cp*log(T1/T2));

//when the same heat loss occurs at lower temperature
I0=m*(Cp*(T3-T4)-T0*Cp*log(T3/T4));



end Ex8_9;
