model Ex9_10

// Variables

Real x1(unit="")                            "Quality of mixture";
Real x2(unit="")                            "Quality of mixture";
Real h2(unit="kJ/kg")                       "Enthalpy";
Real m1(unit="kg")                          "Mass of moisture";


// Parameters
parameter Real m2(unit="kg")=3.24                       "Mass of steam";         
parameter Real V(unit="m^3")=0.150e-03                  "Volume";          
 // According to steam table, at 110 degree celsius 0.1 MPa
 parameter Real h3(unit="kJ/kg")=2696.2                   "Enthalpy of liquid";
 parameter Real hf(unit="kJ/kg")=844.89                   "Enthalpy of liquid";
 parameter Real hfg(unit="kJ/kg")=1947.3                  "Enthalpy of liquid";
 
  
 // According to steam table, at 70 degree celsius 
 parameter Real vf(unit="m^3/kg")=0.001023               "Specific volume";
 
 // Equations
 equation
h2=h3;
x2=(h2-hf)/hfg;
m1=V/vf;
x1=x2*m2/(m1+m2);

end Ex9_10;
