model Ex9_11
// Variables

Real mi(unit="kg")                     "Initial mass of saturated water and steam in the boiler";
Real mf(unit="kg")                     "Final mass of saturated water and steam in the boiler";
Real ms(unit="kg")                     "Mass of steam taken out of the boiler";
Real U1(unit="kJ/kg")                  "Initial energy stored in saturated water and steam";
Real Uf(unit="kJ/kg")                  "Final energy stored in water and steam";
Real Q(unit="MJ")                      "Heat transfer from the external source";

// Parameters
 // According to steam table,at 1 MPa
 parameter Real vf(unit="m^3/kg")=0.001127               "Specific volume of liquid";
 parameter Real vg(unit="m^3/kg")=0.1944                 "Specific volume of gas";
 parameter Real hg(unit="kJ/kg")=2778.1                  "Enthalpy of gas";
 parameter Real uf(unit="kJ/kg")=761.68                  "Internal energy of fluid";
 parameter Real ug(unit="kJ/kg")=2583.6                  "Internal energy of gas";
 parameter Real ufg(unit="kJ/kg")=1822                   "Internal energy";
 
 parameter Real Viw(unit="m^3")=5                   "Initial volume of water";
 parameter Real Vfw(unit="m^3")=4                   "Final volume of water";
 parameter Real Vis(unit="m^3")=5                   "Initial volume of steam";
 parameter Real Vfs(unit="m^3")=6                   "Final volume of steam";
 
 // Equations

equation

mi=(Viw/vf)+(Vis/vg);
mf=(Vfw/vf)+(Vfs/vg);
ms=mi-mf;
U1 =(Viw*uf/vf)+(Vis*ug/vg);
Uf =(Vfw*uf/vf)+(Vfs*ug/vg);
Q = (Uf-U1+(ms*hg))/1e03;

//The  answer may slightly vary due to  rounding off values".
end Ex9_11;
