model Ex9_14

extends Modelica.Math;

// Variables
Real h2(unit="kJ/kg")                        "Enthalpy";
Real w1(unit="kJ/kg")                        "Availability of steam before throttling";
Real w2(unit="kJ/kg")                        "Availability of steam after throttling";
Real w(unit="kJ/kg")                         "Decrease in avability due to throttling";
Real s3s(unit="kJ/kg*K")                     "Entropy";
Real x3(unit="")                             "Dryness fraction";
Real h3s(unit="kJ/kg")                       "Enthalpy";
Real h3(unit="kJ/kg")                        "Enthalpy";
Real x2(unit="")                             "Dryness fraction";
Real s3(unit="kJ/kg*K")                      "Entropy";
Real w3(unit="kJ/kg")                        "Availability of steam at turbine exhaust";
Real W(unit="kJ/kg")                         "Specific work output from the turbine";


// Parameters
  parameter Real T0(unit="K")=293               "Surroundings temperature";
  parameter Real n(unit="")=0.82                "Isentropic efficiency";
 // From the mollier diagram,at 6 MPa and 400 degree celsius
 
 parameter Real h1(unit="kJ/kg")=3177.2              "Enthalpy ";
 parameter Real s1(unit="kJ/kg*K")=6.5408            "Entropy"; 
 
 // From the mollier diagram,at 6 MPa and 20 degree celsius
 
 parameter Real s0(unit="kJ/kg*K")=0.2966           "Entropy";
 parameter Real h0(unit="kJ/kg")=83.96              "Enthalpy of liquid";
 
 
 // At h=3177.2 kJ/kg*K and p=5 MPa, from the superheated steam table
 
 parameter Real s2(unit="kJ/kg*K")=6.63                 "Entropy";
 // From the mollier diagram,at 0.2 MPa
 parameter Real sf(unit="bar")=1.5301                   "Entropy";
 parameter Real sg(unit="kJ/kg*K")=7.1271               "Entropy";
 parameter Real hf(unit="bar")=504.7                    "Enthalpy";
 parameter Real hfg(unit="kJ/kg*K")=2201.9              "Enthalpy";
 
final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

 // Equations

equation
h2=h1;                                      //for throttling
w1=(h1-h0)-T0*(s1-s0);
w2=(h2-h0)-T0*(s2-s0);
w=w1-w2;
s3s=s2;
x3=(s3s-sf)/(sg-sf);
h3s=hf+x3*hfg;
h3=h2-(n*(h1-h3s));
x2=(h3-hf)/hfg;
s3=sf+x2*(sg-sf);
w3=(h3-h0)-T0*(s3-s0);
W=h2-h3;


end Ex9_14;
