model Ex9_3


// Variables

Real h(unit="kJ/kg")                     "Enthalpy";
Real s(unit="kJ/kg*K")                   "Entropy";
Real x(unit="")                          "Ratio";

// Parameters
 // According to steam table, when p=2 MPa
 parameter Real v(unit="m^3/kg")=0.09                   "Specific volume";
 parameter Real vg(unit="m^3/kg")=0.09963               "Specific volume of gas"; 
 parameter Real vf(unit="m^3/kg")=0.001177              "Specific volume of liquid";
 parameter Real sfg(unit="kJ/kg*K")=3.8935              "Entropy";
 parameter Real sf(unit="kJ/kg*K")=2.4474               "Entropy of fluid";
 parameter Real hfg(unit="kJ/kg")=1890.7                "Enthalpy";
 parameter Real hf(unit="kJ/kg")=908.79                 "Enthalpy of fluid";
 
 
 // Equations

equation

x=(v-vf)/(vg-vf);
h=hf+x*hfg;
s=sf+x*sfg;

//Rounding off error is there.

end Ex9_3;
