model Ex9_7


// Variables

Real x(unit="")                                 "Quality of mixture";
Real h2(unit="kJ/kg")                           "Enthalpy";
Real W(unit="kJ/kg")                            "Work output of the turbine";


// Parameters
 // According to steam table,40 degree celsius
 parameter Real psat(unit="kPa")=7.384                   "Saturated pressure";
 parameter Real sfg(unit="kJ/kg*K")=7.6845               "Entropy";
 parameter Real sf(unit="kJ/kg*K")=0.5725                "Entropy of liquid";
 parameter Real hfg(unit="kJ/kg")=2406.7                 "Enthalpy";
 parameter Real hf(unit="kJ/kg")=167.57                  "Enthalpy of liquid";
 // According to steam table,300 degree celsius and 1.5 MPa
 
 parameter Real s1(unit="kJ/kg*K")=6.9189                 "Entropy";
 parameter Real h1(unit="kJ/kg")=3037.6                   "Enthalpy";
 
 // Equations

equation
x=(s1-sf)/sfg;
h2=hf+x*hfg;
W=h1-h2;

end Ex9_7;
