model Ex10_11

// Variables

Real V1(unit ="m^3")                          "Volume at point 1";
Real T2(unit ="K")                            "Temperature at point 2";
Real W1_2(unit ="kJ")                         "Work done for process 1-2";
Real V2(unit ="m^3")                          "Volume at point 2";
Real V3(unit ="m^3")                          "Volume at point 3";
Real W2_3(unit ="kJ")                         "Work done for process 2-3";
Real W(unit ="kJ")                            "Total work transfer";
Real T3(unit ="K")                            "Temperature at point 3";
Real Q(unit ="kJ")                            "Total heat transfer";

// Parameters
  
  parameter Real m(unit ="kg")=0.5               "Mass";
  parameter Real p2(unit ="kPa")=400             "Pressure at point 2";
  parameter Real p1(unit ="kPa")=80              "Pressure at point 1";
  parameter Real T1(unit ="K")=333               "Temperature at point 1";
  parameter Real R(unit ="KJ/kg*K")=0.287        "Gas constant";
  parameter Real y(unit ="")=1.4                 "Specific heat ratio";
  parameter Real Cp(unit ="KJ/kg K")=1.005       "Specific heat at constant pressure";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

V1=m*R*T1/p1;
T2=T1*(p2/p1)^((y-1)/y);
W1_2=m*R*(T1-T2)/(y-1);
V2=V1*(p1/p2)^(1/y);
W2_3=p2*(V1-V2);
W=W1_2+W2_3;
V3=V1;
T3=T2*(V3/V2);
Q=m*Cp*(T3-T2);


//Note : incorrect answer in the textbook.
end Ex10_11;
