model Ex10_13


extends Modelica.Math;
// Variables

Real R(unit ="kJ/kg*K")                         "Gas constant";
Real T2(unit ="K")                              "Temperature at point 2";
Real Cv(unit ="kJ/kg*K")                        "Specific heat at constant volume";
Real Cp(unit ="kJ/kg*K")                        "Specific heat at constant pressure";
Real delta_S(unit ="kJ/kg*K")                   "Entropy change";

// Parameters
  
  parameter Real p1(unit ="kPa")=300               "Pressure at point 1";
  parameter Real p2(unit ="kPa")=300               "Pressure at point 2";
  parameter Real V1(unit ="m^3")=0.07              "Volume at point 1";
  parameter Real V2(unit ="m^3")=0.1               "Volume at point 2";
  parameter Real T1(unit ="K")=353                 "Temperature at point 1";
  parameter Real m(unit ="kg")=0.25                "Mass";
  parameter Real W(unit ="kJ")=25                  "Work done on the gas";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

R=p1*V1/(m*T1);
T2=p2*V2/(m*R);
Cv=W/(m*(T2-T1));
Cp=Cv+R;
delta_S=m*Cp*log(V2/V1);


end Ex10_13;
