package Ex10_4

model Ex10_4_a            
//The fluid is air

extends Modelica.Math;
// Variables
Real T2_T1(unit ="")                             "Temperature ratio"; //T2/T1
Real W(unit = "kJ/kg")                           "Work done per kg of fluid";
Real v2(unit ="m^3/kg")                          "Specific volume";

// Parameters
  parameter Real p2(unit = "bar") =1             "Temperature at state 1";
  parameter Real p1(unit = "bar") =10            "Temperature at state 1";
  parameter Real T2(unit = "K") =573             "Specific volume at state 1";
  parameter Real y(unit = "") =1.4               "Specific heat ratio";
  parameter Real R(unit = "kJ/kg*K") =0.287      "Gas constant";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation
T2_T1=(p2/p1)^((y-1)/y);
W=R*T2*(T2_T1-1)/(1-y);
v2=R*T2_T1*T2/(p2*100);  

//The  answer may slightly vary due to  rounding off values
  end Ex10_4_a;
//=================================================================================================

model Ex10_4_b
    //The fluid is Steam
    
    extends Modelica.Math;
    // Variables
    Real v2(unit = "m^3/kg")                     "Specific volume";
    Real x2(unit = "")                           "Dryness fraction";
    Real s2(unit = "kJ/kg*K")                    "Entropy";
    Real u2(unit = "kJ/kg")                      "Internal energy";
    Real W(unit = "kJ/kg")                       "Work done per kg of fluid";
    
    
    // Parameters
    parameter Real T(unit = "K") = 523 "Temperature at state 1";
    //from the steam table at 300kPa, 250 degree celsius
    
    parameter Real v1(unit = "m^3/kg") =0.2579         "Specific volume";
    parameter Real u1(unit = "kJ/kg") = 2793.2         "Internal energy";
    parameter Real s1(unit = "kJ/kg*K") = 7.1228       "Entropy";
    parameter Real vf(unit = "m^3/kg") =0.001043       "Specific volume";
    parameter Real vfg(unit = "m^3/kg") =1.693         "Specific volume";
    parameter Real sf(unit = "kJ/kg*K") =1.3025        "Entropy";
    parameter Real sfg(unit = "kJ/kg*K")=6.0568        "Entropy";
    parameter Real uf(unit = "kJ/kg")=417.33          "Internal energy";
    parameter Real ufg(unit = "kJ/kg")=2088.7         "Internal energy";
    
   //Equations
   equation 
s2 =s1;
 x2=(s2-sf)/sfg;
 u2=uf+x2*ufg;
 v2=vf+x2*vfg;
 W=u1-u2;
 
 //The  answer may slightly vary due to  rounding off values.
 end Ex10_4_b;
 
 
end Ex10_4;
