model Ex10_7

extends Modelica.Math;
// Variables
Real ma(unit ="kg")                             "Mass of vessel A";
Real R(unit ="kJ/kg*K")                         "Characterstic gas constant of nitrogen";
Real Va(unit ="m^3")                            "Volume of vessel A";
Real Vb(unit ="m^3")                            "Volume of vessel B";
Real V(unit ="m^3")                             "Total volume";
Real m(unit ="kg")                              "Mass";
Real p1(unit ="kPa")                            "Pressure";
Real Cv(unit ="kJ/kg*K")                        "Specific heat at constant volume";
Real U1(unit ="kJ")                             "Internal energy of vessel A";
Real U2(unit ="kJ")                             "Internal energy of vessel B";
Real Q(unit ="kJ")                              "Heat transfer";
Real Tf(unit ="K")                              "Final temperature";
Real p2(unit ="kPa")                            "Final pressure";

// Parameters
  
  parameter Real ua(unit ="kg/kg mol")=28           "Pressure of vessel A";
  parameter Real pa(unit ="kPa")=1500               "Pressure of vessel A";
  parameter Real pb(unit ="kPa")=600                "Pressure of vessel B";
  parameter Real Ta(unit ="K")=323                  "Temperature of vessel A";
  parameter Real Tb(unit ="K")=293                  "Temperature of vessel B";
  parameter Real T(unit ="K")=300                   "Final temperature after mixing";
  parameter Real na(unit ="kg mole")=0.5            "Mass of mole";
  parameter Real mb(unit ="kg")=2.5                 "Mass of vessel B";
  parameter Real R0(unit ="kJ/kg*K")=8.3143         "Gas constant";
  parameter Real y(unit ="")=1.4                    "Specific heat ratio";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

ma=na*ua;
R=R0/ua;
Va=ma*R*Ta/pa;
Vb=mb*R*Tb/pb;
V=Va+Vb;
m=ma+mb;
p1=m*R*T/V;
Cv=R/(y-1);
U1=Cv*(ma*Ta+mb*Tb);
U2=m*Cv*T;
Q=U2-U1;
Tf=(ma*Ta+mb*Tb)/m;
p2=m*R*Tf/V;

end Ex10_7;
