model Ex10_8

// Variables

Real R(unit ="kJ/kg*K")                        "Gas constant";
Real u(unit ="kg/kg-mol")                      "Molecular weight";
Real Q(unit ="kJ")                             "Heat transfer at constant volume";
Real delta_U(unit ="kJ")                       "Change in internal energy";
Real delta_H(unit ="kJ")                       "Change in enthalpy";
Real delta_S(unit ="kJ/K")                     "Change in entropy";


// Parameters
  
  parameter Real Ro(unit ="kg/kg mol")=8.3143       "Gas constant";
  parameter Real Cp(unit ="kJ/kg*K")=1.968          "Specific heat at constant pressure";
  parameter Real Cv(unit ="kJ/kg*K")=1.507          "Specific heat at constant volume";
  parameter Real T1(unit ="K")=278                  "Temperature at point 1";
  parameter Real T2(unit ="K")=373                  "Temperature at point 2";
  parameter Real m(unit ="kg")=2                    "Mass of gas";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations

equation

R=Cp-Cv;
u=Ro/R;
Q=m*Cv*(T2-T1);
delta_U=Q;
delta_H=m*Cp*(T2-T1);
delta_S=m*Cv*log(T2/T1);


// The  answer provided in the textbook is wrong.

end Ex10_8;
