model Ex12_2

extends Modelica.Math;
// Variables
Real hf(unit ="kJ/kg")              "Enthalpy";
Real s2(unit ="kJ/kg-K")              "Entropy";
Real sf(unit ="kJ/kg-K")              "Entropy";
Real x2(unit ="")                    "Dryness fraction";
Real h2(unit ="kJ/kg")               "Enthalpy";
Real Wp1(unit ="kJ/kg")              "Pump work";
Real Wt1(unit ="kJ/kg")              "Turbine work";
Real W_net1(unit ="kJ/kg")           "Net Work done";
Real Q1(unit ="kJ/kg")               "Heat transfer";
Real n1(unit ="")                    "Cyclic efficiency";
Real Wp2(unit ="kJ/kg")              "Pump work";
Real Wt2(unit ="kJ/kg")              "Turbine work";
Real W_net2(unit ="kJ/kg")           "Net Work done";
Real W_per(unit ="kJ/kg")            "Reduction in work output";
Real h_4(unit ="kJ/kg")              "Enthalpy";
Real Q(unit ="kJ/kg")                "Heat transfer";
Real n2(unit ="")                    "Cyclic efficiency";
Real n_per(unit ="%")            "Reduction in cycle efficiency";


// Parameters
  
//steam is a saturated liquid initially.
  parameter Real h1(unit ="kJ/kg")=3159.3            "Enthalpy";
  parameter Real h3(unit ="kJ/kg")=173.88               "Enthalpy";
  parameter Real hfg(unit ="kJ/kg")=2403.1              "Enthalpy";
  parameter Real h4(unit ="kJ/kg")=175.89            "Enthalpy";
  parameter Real s1(unit ="kJ/kg-K")=6.9917            "Entropy";
  parameter Real s3(unit ="kJ/kg-K")=0.5926               "Entropy";
  parameter Real sfg(unit ="kJ/kg-K")=7.6361              "Entropy";
  parameter Real vf(unit ="m^3/kg")=0.001008             "Specific Volume";
  parameter Real p1(unit ="kPa")=2000                 "Pressure";
  parameter Real p2(unit ="kPa")=8                    "Pressure";
  parameter Real np(unit ="")=0.8                     "Pump efficiency";
  parameter Real nt(unit ="")=0.8                     "Turbine efficiency";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations

equation

hf=h3;
s2=s1;
sf=s3;
x2=(s2-sf)/sfg;
h2=hf+x2*hfg;
Wp1=vf*(p1-p2);
Wt1=h1-h2;
W_net1=Wt1-Wp1;
Q1=h1-h4;
n1=W_net1/Q1;
Wp2=Wp1/np;
Wt2=Wt1*nt;
W_net2=Wt2-Wp2;
W_per=(W_net1-W_net2)*100/W_net1;
h_4=h3+Wp2;
Q=h1-h_4;
n2=W_net2/Q;
n_per=(n1-n2)*100/n1;

end Ex12_2;
