model Ex12_9

extends Modelica.Math;
// Variables

Real ws(unit ="kg/s")                         "Mass flow rate";
Real Wnet(unit ="kJ/s")                       "Net work done";
Real h1_2s(unit ="kJ/kg")                     "Enthalpy";
Real h12(unit ="kJ/kg")                       "Enthalpy";
Real h2(unit ="kJ/kg")                        "Enthalpy";
Real h1(unit ="kJ/kg")                        "Enthalpy";
Real h2s(unit ="kJ/kg")                       "Enthalpy";
Real x2s(unit ="")                            "Dryness fraction";
Real s2s(unit ="kJ/kg*K")                     "Entropy";
Real s1(unit ="kJ/kg*K")                      "Entropy";
Real P1(unit ="bar")                          "Pressure";
Real t1(unit ="degree celsius")               "Temperature";

// Parameters
  //From steam table, at 40 bar
  parameter Real hfg(unit ="kJ/kg")=2202.6              "Enthalpy";  //h2-h3
  parameter Real hg(unit ="kJ/kg")=2706.3               "Enthalpy";
  parameter Real hf(unit ="kJ/kg")=503.71               "Enthalpy";  
  parameter Real W(unit ="kW")=1000                     "Work done";
  parameter Real Qh(unit ="kW")=5.83e03                 "Heat transfer";
  parameter Real n_generator(unit ="")=0.9              "Efficiency of generator";
  parameter Real n_internal(unit ="")=0.85              "Internal Efficiency";
  parameter Real n_brake(unit ="")=0.80                 "Brake power Efficiency";
  parameter Real sfg(unit ="kJ/kg*K")=5.6020            "Entropy";  
  parameter Real sf(unit ="kJ/kg*K")=1.5276             "Entropy";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations

equation

ws=Qh/hfg;
Wnet=W/n_generator;
h1_2s = Wnet/(ws*n_brake); 			//h1-h2
h12 = n_internal*h1_2s; 
h2 = hg;
h1 = h12+h2;
h2s = h1-h1_2s;
x2s = (h2s-hf)/hfg;
s2s = sf+(x2s*sfg);
s1 = s2s;
//from the Mollier chart
P1 = 22.5; 			
t1 = 360;

end Ex12_9;
