model Ex13_1

extends Modelica.Math;
// Variables

Real n_cycle(unit ="")                       "Cyclic Efficiency";
Real v1(unit ="m^3/kg")                      "Specific volume";
Real v2(unit ="m^3/kg")                      "Specific volume";
Real T2(unit ="K")                           "Temperature";
Real T3(unit ="K")                           "Temperature";
Real Tmax(unit ="K")                         "Maximum Temperature";
Real p2(unit ="MPa")                         "Pressure";
Real p3(unit ="MPa")                         "Pressure";
Real W_net(unit ="kJ/kg")                    "Net work";
Real pm(unit ="kPa")                         "Mean effective Pressure";
Real mep(unit ="kPa")                        "Mean effective Pressure";

// Parameters
  //From steam table, at 40 bar
  
  parameter Real T1(unit ="K")=308                  "Temperature";  
  parameter Real p1(unit ="MPa")=0.1                "Pressure";
  parameter Real Q1(unit ="kJ/kg")=2100             "Heat supplied";
  parameter Real r(unit ="")=8                      "Compression ratio";  
  parameter Real y(unit ="")=1.4                    "Specific heat ratio";
  parameter Real Cv(unit ="kJ/kg*K")=0.718          "Specific heat at constant volume";
  parameter Real R(unit ="kJ/kg*K")=0.287           "Gas constant";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

n_cycle=1-(1/r^(y-1));
v1=R*T1/(p1*1e03);
v2=v1/8;
T2=T1*((v1/v2)^(y-1));
T3=T2+(Q1/Cv);
Tmax=T3;
p2=p1*((v1/v2)^y);
p3=p2*T3/T2;
W_net=Q1*n_cycle;
pm=W_net/(v1-v2);
mep=pm;

end Ex13_1;
