model Ex13_4

extends Modelica.Math;
// Variables

Real p2(unit ="bar")                  "Pressure";
Real T2(unit ="K")                    "Temperature";
Real T3(unit ="K")                    "Temperature";
Real Q2_3(unit ="kJ/kg")              "Heat transfer";
Real Q3_4(unit ="kJ/kg")              "Heat transfer";
Real T4(unit ="K")                    "Temperature";
Real v4_3(unit ="m^3/kg")             "Specific volume";
Real v5_4(unit ="m^3/kg")             "Specific volume";
Real v4_5(unit ="m^3/kg")             "Specific volume";
Real T5(unit ="K")                    "Temperature";
Real p5(unit ="bar")                  "Pressure";
Real Q2(unit ="kJ/kg")                "Heat rejected";
Real Q1(unit ="kJ/kg")                "Heat supplied";
Real n_cycle(unit ="")                "Cyclic Efficiency";
Real v1(unit ="m^3/kg")               "Specific volume";
Real delta_v(unit ="m^3/kg")          "Specific volume";        //v1-v2
Real Wnet(unit ="kJ/kg")              "Net work done";
Real mep(unit ="kN/m^2")              "Mean effective pressure";

// Parameters
  
  parameter Real v1_2(unit ="")=16                     "Specific volume ratio"; //v1/v2 
  parameter Real T1(unit ="K")=323                     "Temperature";
  parameter Real p3(unit ="bar")=70                    "Pressure";
  parameter Real p1(unit ="bar")=1                     "Pressure";
  parameter Real Cp(unit ="kJ/kg*K")=1.005             "Specific heat at constant pressure";
  parameter Real Cv(unit ="kJ/kg*K")=0.718             "Specific heat at constant volume";
  parameter Real y(unit ="")=1.4                       "Specific heat ratio";
  parameter Real R(unit ="kJ/kg*K")=0.287              "Gas constant";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations

equation

T2=T1*((v1_2)^(y-1));
p2=p1*((v1_2)^y);
T3=T2*p3/p2;
Q2_3=Cv*(T3-T2);                               //Q3-Q2
Q3_4=Q2_3;                                     //Q4-Q3
T4=T3+(Q3_4/Cp);
v4_3=T4/T3;                                    //v4/v3
v5_4=v1_2/v4_3;                                //v5/v4
v4_5=1/v5_4;                                   //v4/v5
T5=T4*(v4_5^(y-1));
p5=p1*T5/T1;
Q2=Cv*(T5-T1);
Q1=Cv*(T3-T2)+Cp*(T4-T3);
n_cycle=1-(Q2/Q1);
v1=R*T1/(p1*1e02);
delta_v=(15/16)*v1;
Wnet=Q1*n_cycle;
mep=Wnet/delta_v;


end Ex13_4;
