model Ex13_5

extends Modelica.Math;
// Variables

Real T2s(unit ="K")                           "Temperature";
Real T4s(unit ="K")                           "Temperature";
Real T2_1(unit ="K")                          "Temperature "; 
Real T3_4(unit ="K")                          "Temperature";
Real Wt(unit ="kJ/kg")                        "Turbine work";
Real Wc(unit ="kJ/kg")                        "Compressor work";
Real Q1(unit ="kJ/kg")                        "Heat supplied";
Real n(unit ="%")                             "Effeicency without regeneration";
Real T2(unit ="K")                            "Temperature";
Real T4(unit ="K")                            "Temperature";
Real T6(unit ="K")                            "Temperature";
Real Q_1(unit ="kJ/kg")                       "Heat supplied";
Real n_(unit ="%")                            "Effeicency due to regeneration";
Real percentage_increase(unit ="%")           "Percentage increase due to regeneration";


// Parameters
  
  parameter Real p2_1(unit ="")=6                  "Pressure ratio";     //P2/P1
  parameter Real T1(unit ="K")=303                 "Temperature";
  parameter Real nC(unit ="")=0.8                  "Compressor efficiency";
  parameter Real nT(unit ="")=0.8                  "Turbine efficiency";
  parameter Real Cp(unit ="kJ/kg*K")=1.005         "Specific heat at constant pressure";
  parameter Real T3(unit ="K")=1173                "Temperature";
  parameter Real y(unit ="")=1.4                   "Specific heat ratio";
  parameter Real E(unit ="")=0.75                  "Effectiveness";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations

equation
//Without regenerator

T2s=T1*((p2_1)^((y-1)/y));            
T4s=T3/((p2_1)^((y-1)/y));
T2_1=(T2s-T1)/nC;                             //T2-T1
T3_4=(T3-T4s)*nT;                             //T3-T4
Wt=Cp*T3_4;
Wc=Cp*T2_1;
T2=T2_1+T1;
Q1=Cp*(T3-T2);
n=(Wt-Wc)*100/Q1;
//With regenerator
T4=T3-T3_4;
T6=(E*(T4-T2))+T2;
Q_1=Cp*(T3-T6);
n_=(Wt-Wc)*100/Q_1;
percentage_increase=(n_-n)*100/n;


//RThe  answer may slightly vary due to  rounding off values.
end Ex13_5;
