model Ex13_7

extends Modelica.Math;
// Variables

Real n_cycle(unit ="")                        "Cyclic efficiency";
Real T2_1(unit ="")                          "Temperature ratio";
Real T2(unit ="K")                            "Temperature";
Real T3_4(unit ="")                          "Temperature ratio";
Real T4(unit ="K")                            "Temperature";
Real Wc(unit ="kJ/kg")                        "Compressor work";
Real Wt(unit ="kJ/kg")                        "Turbine work";
Real WR(unit ="")                             "Work ratio";
Real PO(unit ="MW")                           "Power output";
Real m(unit ="kg/s")                          "Mass flow rate";
Real T0(unit ="K")                            "Surrounding Temperature";
Real E(unit ="MW")                            "Exergy flow rate of the exhaust gas stream";

// Parameters
  
  parameter Real rp(unit ="")=6                "Pressure ratio";  
  parameter Real T1(unit ="K")=300             "Temperature";
  parameter Real T3(unit ="K")=1100            "Temperature";
  parameter Real Q(unit ="MW")=100             "Heat supply";
  parameter Real Cp(unit ="kJ/kg*K")=1.005     "Specific heat at constant pressure";
  parameter Real y(unit ="")=1.4               "Specific heat ratio";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

n_cycle=1-(1/rp^((y-1)/y));
T2_1=rp^((y-1)/y);                     //T2/T1
T2=T1*rp^((y-1)/y);
T3_4=T2_1;                             //T3/T4
T4=T3/T3_4;
Wc=Cp*(T2-T1);
Wt=Cp*(T3-T4);
WR=(Wt-Wc)/Wt;
PO=Q*n_cycle;
m=(Q*1e03)/(Cp*(T3-T2));
T0=T1;
E=m*Cp*T0*((T4/T0)-1-log(T4/T0))*1e-03;



end Ex13_7;
