model Ex14_9

extends Modelica.Math;
// Variables

Real T2s(unit ="K")                      "Temperature";
Real T2(unit ="K")                       "Temperature";
Real p3(unit ="bar")                     "Pressure";
Real p4(unit ="bar")                     "Pressure";
Real P(unit ="")                         "Pressure ratio for the turbine";
Real T4s(unit ="K")                      "Temperature";
Real T4(unit ="K")                       "Temperature";
Real COP(unit ="")                       "Coefficient of performance";


// Parameters
  parameter Real T1(unit ="K")=275               "Temperature";   
  parameter Real T3(unit ="K")=310               "Temperature";
  parameter Real p1(unit ="bar")=1               "Pressure";  
  parameter Real p2(unit ="bar")=4               "Pressure";
  parameter Real nc(unit ="")=0.8                "Compressor efficiency";
  parameter Real nt(unit ="")=0.85               "Turbine efficiency";
  parameter Real pr1(unit ="bar")=0.1            "Loss in the cooler";
  parameter Real pr2(unit ="bar")=0.08           "Loss in the cold chamber";
  parameter Real y(unit ="")=1.4                 "Specific heat ratio";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

T2s=T1*((p2/p1)^((y-1)/y));
T2=T1+((T2s-T1)/nc);
p3=p2-pr1;
p4=p1+pr2;
P=p3/p4;
T4s=T3/(P^((y-1)/y));
T4=T3-((T3-T4s)*nt);
COP=(T1-T4)/((T2-T3)-(T1-T4));

end Ex14_9;
