model Ex16_11

extends Modelica.Math;
// Variable

Real Wrev(unit ="kJ/kg-mol")                      "Reversible work done";
Real Wrev_(unit ="kJ/kg")                         "Reversible work done";
Real Sr(unit ="kJ/kg-mol-K")                      "Entropy of the reactants";
Real Sp(unit ="kJ/kg-mol-K")                      "Entropy of the products";
Real IE(unit ="kJ/kg-mol-K")                      "Increase in entropy during combustion";
Real I(unit ="kJ/kg")                             "Irreversibility of the process";
Real A(unit ="kJ/kg")                             "Availability of combustion products";

// Parameters

  parameter Real T0(unit ="K")=298                     "Temperature";  
  parameter Real Hr(unit ="kJ")=-103847                 "Reactants energy";  
  parameter Real T(unit ="K")=980                      "Through trial and error";
  parameter Real gf0_C3H8(unit ="kJ")=-23316            "";
  parameter Real gf0_Co2(unit ="kJ")=-394374            "";
  parameter Real gf0_H2O(unit ="kJ")=-228583            "";
  parameter Real s0_C3H8_298(unit ="kJ")=270.019        "";
  parameter Real s0_O2_298(unit ="kJ")=205.142          "";
  parameter Real s0_N2_298(unit ="kJ")=191.611          "";
  parameter Real s0_Co2_980(unit ="kJ")=268.194         "";
  parameter Real s0_H2O_980(unit ="kJ")=231.849         "";
  parameter Real s0_O2_980(unit ="kJ")=242.855          "";
  parameter Real s0_N2_980(unit ="kJ")=227.485          ""; 
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation

Wrev = gf0_C3H8-(3*gf0_Co2)-(4*gf0_H2O);
Wrev_ = Wrev/44; 
Sr = s0_C3H8_298+(20*s0_O2_298)+(75.2*s0_N2_298);
Sp = (3*s0_Co2_980) + (4*s0_H2O_980) + (15*s0_O2_980) + (75.2*s0_N2_980);
IE = Sp-Sr; 			// 
I = T0*3699.67/44;
A = Wrev_ - I;

//The  answer may slightly vary due to  rounding off values.
//
end Ex16_11;
